DROP PROCEDURE [hips].[PatientMasterAddressInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 Oct 2012
-- Description:   Inserts a record into the Patien Master Address Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterAddressInsert] 
(
	@PatientMasterId INT,
	@AddressId INT,
	@UserModified varchar(256)
)
AS
BEGIN
	SET NOCOUNT ON

    DECLARE @intErrorCode int

    SET @intErrorCode = 0

	INSERT INTO hips.PatientMasterAddress
	        ( PatientMasterId ,
	          AddressId ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  (	@PatientMasterId,
				@AddressId,
				GETDATE(),
				@UserModified,
				GETDATE(),
				@UserModified
	
	        )
	SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
        SELECT PatientMasterId,
                AddressId,
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[PatientMasterAddress]
         WHERE [PatientMasterId] = @PatientMasterId
         AND [AddressId] = @AddressId
    END

    RETURN(@intErrorCode)


END
GO

